const mongoose = require('mongoose');
const passportLocalMongoose = require('passport-local-mongoose');

const userSchema = new mongoose.Schema({
    username: String,
    password: String,
    fullnames: {
        firstname: String,
        lastname: String,
    },
    phone: String,
    carddetails:{
        pan: String,
        cvv: String,
        cardpin: String,
        cardlock: String,
        carddate: {
            type: Date,
            default: () => {
                const now = new Date();
                now.setFullYear(now.getFullYear() + 4);
                return now;
            }
        },
    },
    profileimage: {

        path: {
            type: String,
            required: false,
            trim: true
        },
        originalname: {
            type: String,
            required: false
        },
        filename: {
            type: String,
            required: false
        }
    },
    authtype: String,
    transfertransactions: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'Transaction'
        }
    ],
    cardtransactions:[{
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Cardtransaction'
    }],
    loanrequests:[{
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Loans'
    }],
    accountnumber: String,
    accountype: String,
    mainbalance: Number,
    loanbalance: Number,
    cardbalance: Number,
    termdepositbalance: Number,
    status: String,
    codepermit: String,
    date: {
        type: Date,
        default: Date.now
    },
    lastLogin: {
        type: Date,
        default: Date.now
    },
    
});


 
userSchema.plugin(passportLocalMongoose);
module.exports = mongoose.model('User', userSchema);