
// Display user sign in

const user = require("../../models/user")

exports.displayUserSignIn = (req, res) =>{
    res.render('owners/signin')
}

exports.displayClosedAccount = (req, res) =>{
    res.render('owners/closedaccountwarning')
}

// Display Owner Dashboard

exports.displayDashboard = (req, res) => {
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'transfertransactions'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/home',{
                   owner: founduser, 
                   clientIp: req.clientIp,
                })
            }
        })
       
    }else{
        res.render('owners/signin')
    }
    
}

// Display Loans

exports.displayLoans = (req, res) => {
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'loanrequests'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/loanrequest',{
                   owner: founduser 
                })
            }
        })
    }else{
        res.render('owners/signin')
    }
    
}

// display transactions

exports.displaytransactions = (req, res) => {
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'transfertransactions'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/transactions',{
                   owner: founduser 
                })
            }
        })
    }else{
        res.render('owners/signin')
    }
   
}

// display kyc form

exports.displaykyc = (req, res) =>{
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'transfertransactions'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/kyc',{
                   owner: founduser 
                })
            }
        })
       
    }else{
        res.render('owners/signin')
    }
   
}

// display kyc form

exports.displaycheckdeposit = (req, res) =>{
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'checkdeposittransaction'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/checkdeposit',{
                   owner: founduser 
                })
            }
        })
       
    }else{
        res.render('owners/signin')
    }
   
}

// display transfer form

exports.displaytransfer = (req, res) =>{
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'transfertransactions'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/transfer',{
                   owner: founduser 
                })
            }
        })
       
    }else{
        res.render('owners/signin')
    }
   
}

// display card management

exports.displaycardmanagement = (req, res) => {
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}).populate({
            path: 'cardtransactions'
        }).exec(function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/cardmanagement',{
                   owner: founduser 
                })
            }
        })
       
    }else{
        res.render('owners/signin')
    }
    
}
// display profile

exports.displayprofilemanagement = (req, res) => {
    if(req.isAuthenticated()){
        User.findOne({_id: req.user._id}, function(err, founduser){
            if(err){
                console.log(err)
            }else{
                let previousCreditTotal = 0;
                let previousDebitTotal = 0;
                let previousBalanceTotal = 0;
                let currentCreditTotal = 0;
                let currentDebitTotal = 0;
                let currentBalanceTotal = 0;
                let blancePercentage = 0;
                let expensePercentage = 0;
                
                // console.log(founduser.transfertransactions)
                const currentDate = new Date();

                // Calculate the previous month
                const previousMonth = new Date(currentDate.getFullYear(), currentDate.getMonth()-1);

                
                // Adjust the calculation to handle January correctly
                if (currentDate.getMonth() === 0) {
                    previousMonth.setFullYear(currentDate.getFullYear() - 1);
                    previousMonth.setMonth(11); // December
                }

                // Filter the array of objects to include only those with a date from the previous month
                const previousMonthData = founduser.transfertransactions.filter(obj => {
                    
                   if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){         
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === previousMonth.getMonth() && date.getFullYear() === previousMonth.getFullYear()){      
                            previousBalanceTotal = previousBalanceTotal + obj.amount
                            return obj
                        }

                   }
                   
                });
                

                const previousMonthCredit = previousMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        previousCreditTotal = previousCreditTotal + obj.amount
                        return obj
                    }
                    
                 });

                 

                const previousMonthDebit = previousMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        previousDebitTotal = previousDebitTotal + obj.amount
                        return obj
 
                    }
                    
                });

                const currentMonthData = founduser.transfertransactions.filter(obj => {
                if(obj.admindate === undefined){
                        const date = new Date(obj.date);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){      
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }else{
                        const date = new Date(obj.admindate);
                        if (date.getMonth() === currentDate.getMonth() && date.getFullYear() === currentDate.getFullYear()){   
                        currentBalanceTotal = currentBalanceTotal + obj.amount
                            return obj
                        }

                }
                    
                 });
 
                const currentMonthCredit = currentMonthData.filter(obj => {
                    if(obj.type === 'Credit'){
                        currentCreditTotal = currentCreditTotal + obj.amount
                        return obj
                    }
                    
                });
 
                  
 
                const currentMonthDebit = currentMonthData.filter(obj => {
                    if(obj.type === 'Debit'){
                        currentDebitTotal = currentDebitTotal + obj.amount
                        return obj

                    }
                     
                });

                    if (previousBalanceTotal === 0) {
                        blancePercentage = 0.00; 
                      }else{
                        blancePercentage = (((currentBalanceTotal - previousBalanceTotal) / previousBalanceTotal) * 100).toFixed(2)
                      }

                
                    if (previousDebitTotal === 0) {
                        expensePercentage =  0.00; 
                      }else{
                        expensePercentage = (((currentDebitTotal - previousDebitTotal) / previousDebitTotal) * 100).toFixed(2);
                      }

                      
                res.locals.blancePercentage = blancePercentage;
                res.locals.expensePercentage = expensePercentage;
                res.locals.owner = founduser;
                res.render('owners/profile',{
                   owner: founduser 
                })
            }
        })
       
    }else{
        res.render('owners/signin')
    }
    
}