const path = require('path');
const multer = require('multer');

const storage = multer.diskStorage({
    destination: function(req, file, cb){
        cb(null, 'uploads/') 
    },
    filename: function(req, file, cb){
        cb(null, file.fieldname + '-' + Date.now() + path.extname(file.originalname));
    }
});
const upload = multer({
    storage: storage
});



module.exports = function(app){
    const viewsroutes = require('../controllers/owners/views')
    const adminviewsroutes = require('../controllers/admin/views')
    const adminactions = require('../controllers/admin/actions')
    const owneractions = require('../controllers/owners/auth')
    const ownercreate = require('../controllers/owners/actions')

    app.route('/')
    .get(viewsroutes.displayDashboard);

    app.route('/control-auth')
    .get(adminviewsroutes.displayAdminSignIn)
    .post(adminactions.admin_sign_in)

    app.route('/auth-profile')
    .get(adminviewsroutes.displayprofilemanagement)

    app.route('/update-admin')
    .post(adminactions.update_adminprofile)

    app.route('/auth-logout')
    .get(adminactions.logout)

    app.route('/control-reg')
    .get(adminviewsroutes.displayAdminSignUp)
    .post(adminactions.create_admin)

    app.route('/login')
    .get(viewsroutes.displayUserSignIn)
    .post(owneractions.sign_in)

    app.route('/loans')
    .get(viewsroutes.displayLoans)

    app.route('/transactions')
    .get(viewsroutes.displaytransactions)

    app.route('/transfer-funds')
    .get(viewsroutes.displaytransfer)

    app.route('/card-management')
    .get(viewsroutes.displaycardmanagement);

    app.route('/control')
    .get(adminviewsroutes.displayDashboard);

    app.route('/create-new-owner')
    .post(adminactions.create_new_user)

    app.route('/edit-user/:userid')
    .get(adminviewsroutes.displayuserprofile)

    app.route('/update-user-profile')
    .post(upload.single('profileimage'), adminactions.update_user_profile);

    app.route('/update-user-account')
    .post(adminactions.edit_user_account)

    app.route('/create-user-transactions')
    .post(adminactions.create_transaction)

    app.route('/edit-user-transaction/:userid/:transactionid')
    .get(adminviewsroutes.view_edit_transaction)

    app.route('/update-user-transaction')
    .post(adminactions.update_transaction)

    app.route('/delete-user-transaction/:userid/:transactionid')
    .get(adminactions.delete_transaction)

    app.route('/create-user-cardtransactions')
    .post(adminactions.create_card_transaction)

    app.route('/edit-user-cardtransaction/:userid/:cardtransactionid')
    .get(adminviewsroutes.view_edit_cardtransaction)

    app.route('/update-user-cardtransaction')
    .post(adminactions.update_cardtransaction)

    app.route('/delete-user-cardtransaction/:userid/:transactionid')
    .get(adminactions.delete_cardtransaction)

    app.route('/create-otp')
    .get(adminactions.create_otp)

    app.route('/create-cot')
    .get(adminactions.create_cot)

    app.route('/create-taxcode')
    .get(adminactions.create_taxcode)

    app.route('/view-otp')
    .get(adminviewsroutes.view_otp_generate)

    app.route('/view-cot')
    .get(adminviewsroutes.view_cot_generate)

    app.route('/view-taxcode')
    .get(adminviewsroutes.view_taxcode_generate)

    app.route('/transferfunds')
    .post(ownercreate.create_transaction_user)

    app.route('/validate-otp')
    .post(ownercreate.validate_transaction_otp)

    app.route('/validate-tc')
    .post(ownercreate.validate_transaction_tc)

    app.route('/create-loans')
    .post(ownercreate.create_loans)

    app.route('/create-loans-admin')
    .post(adminactions.create_loans_admin)

    app.route('/update-card')
    .post(ownercreate.update_card)

    app.route('/my-settings')
    .get(viewsroutes.displayprofilemanagement)

    app.route('/update-my-profile')
    .post(upload.single('profileimage'), ownercreate.update_myprofile);

    app.route('/logout-user')
    .get(owneractions.logout)

    app.route('/delete-user/:userid')
    .get(adminactions.delete_user)

    app.route('/delete-user-loan/:userid/:loansid')
    .get(adminactions.delete_loan_transaction)

    app.route('/edit-user-loans/:userid/:loansid')
    .get(adminviewsroutes.view_edit_loans)

    app.route('/update-user-loan')
    .post(adminactions.update_user_loan)
}

